package cn.com.duiba.bigdata.common.biz.enums;

/**
 * @author xugf 2023-11-28
 * 条件操作符
 */
public enum OperatorsEnum {

    //维度和属性操作符

    //等于单个值或者多个值
    IN(" in (${value})", 1),

    //不等于单个值或者多个值
    NOT_IN(" not in (${value})", 1),

    //数组过滤
    ARRAY(" && ARRAY[${value}]", 1),

    //字段为空
    IS_NULL(" is null", 1),

    //字段不为空
    IS_NOT_NULL(" is not null", 1),

    //包含（只适用于属性条件过滤）
    LIKE(" like ", 1),

    //不包含（只适用于属性条件过滤）
    NOT_LIKE(" not like ", 1),

    //holo jsonb操作符
    JSONB(" ::jsonb ->> '${value}'", 1),





    //指标操作符

    //大于
    GT(" > ", 2),

    //大于等于
    GE(" >= ", 2),

    //等于
    EQ(" = ", 2),

    //小于
    LT(" < ", 2),

    //小于等于
    LE(" <= ", 2)

    ;



    //操作符
    private final String symbol;

    //适用类型（1: 维度 2: 指标）
    private final int type;

    OperatorsEnum(String symbol, int type) {
        this.symbol = symbol;
        this.type = type;
    }

    public String getSymbol() {
        return symbol;
    }

    public int getType() {
        return type;
    }
}
