package cn.com.duiba.bigdata.common.biz.enums;

import cn.com.duiba.bigdata.common.biz.interfaces.CombineMetricEnum;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xugf 2023-11-27
 * 推啊业务线-组合类指标字段
 */
public enum TuiaCombineMetricEnum implements CombineMetricEnum {

    //理论消耗（单位：分）：cpc消耗 + 前端转化消耗 + 后端转化消耗
//    THEORY_CONSUME("CPC_CONSUME,LP_CLICK_CONSUME,BACKEND_EFFECT_CONSUME", "sum(cpcConsume) + sum(lpClickConsume) + sum(backendEffectConsume)", "theoryConsume", "理论消耗（单位：分）：cpc消耗 + 前端转化消耗 + 后端转化消耗"),

    //目标转化pv：前端目标转化pv + 后端目标转化pv
//    TARGET_EFFECT_PV("LP_TARGET_EFFECT_PV,BACKEND_TARGET_EFFECT_PV", "sum(lpTargetEffectPV) + sum(backendTargetEffectPV)", "targetEffectPV", "目标转化pv：前端目标转化pv + 后端目标转化pv"),

    //目标转化uv（根据tuia_id去重）：前端目标转化uv + 后端目标转化uv
//    TARGET_EFFECT_UV("LP_TARGET_EFFECT_UV,BACKEND_TARGET_EFFECT_UV", "sum(lpTargetEffectUV) + sum(backendTargetEffectUV)", "targetEffectUV", "目标转化uv（根据tuia_id去重）：前端目标转化uv + 后端目标转化uv"),




    ;


    //组合的基础指标列表，多个指标用 "," 分隔
    private final String metricList;

    //指标sql代码段
    private final String metricSql;

    //结果数据对应的别名
    private final String resultFieldName;

    //指标解释说明
    private final String desc;

    //枚举列表
    public static final List<String> enumList = new ArrayList<>();

    TuiaCombineMetricEnum(String metricList, String metricSql, String resultFieldName, String desc) {
        this.metricList = metricList;
        this.metricSql = metricSql;
        this.resultFieldName = resultFieldName;
        this.desc = desc;
    }

    public String getMetricList() {
        return metricList;
    }

    public String getMetricSql() {
        return metricSql;
    }

    public String getResultFieldName() {
        return resultFieldName;
    }

    public String getDesc() {
        return desc;
    }

    static {
        TuiaCombineMetricEnum[] values = TuiaCombineMetricEnum.values();
        for (TuiaCombineMetricEnum value : values) {
            enumList.add(value.toString());
        }
    }

}
