package cn.com.duiba.bigdata.common.biz.form;

import cn.com.duiba.bigdata.common.biz.dto.KeyValueDto;
import cn.com.duiba.bigdata.common.biz.dto.SortDto;
import cn.com.duiba.bigdata.common.biz.enums.HologresShowTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xugf 2023-11-28
 * hologres 数据查询对象
 */
@Data
public class HoloQueryForm implements Serializable {

    private static final long serialVersionUID = 8439770695432063040L;

    //查询的开始时间 时间格式: yyyy-MM-dd HH:mm:ss（必填）
    private String startTime;

    //查询的结束时间 时间格式: yyyy-MM-dd HH:mm:ss（必填）
    private String endTime;

    //基础指标、计算类指标、组合指标，必须要有一个
    //本次查询的基础指标列表（推啊业务线：TuiaMetricEnum）
    private List<String> metricList;

    //本次查询的计算类指标列表（推啊业务线：TuiaCalculateMetricEnum）
    private List<String> calculateMetricList;

    //本次查询的组合指标列表（推啊业务线：TuiaCombineMetricEnum）
    private List<String> combineMetricList;

    //本次查询的维度列表（推啊业务线：TuiaDimensionEnum）
    private List<String> dimensionList;

    //本次查询的条件
    private List<KeyValueDto> conditionList;

    //排序的字段(当前支持单一字段排序)
    private SortDto orderByMetric;

    //数据展示格式, 默认直接返回查询时段内的所有数据，取值参照 HologresShowTypeEnum
    private String dataShowType = HologresShowTypeEnum.ALL.toString();

    //每页展示的记录条数
    private Integer pageSize;

    //当前页面号
    private Integer pageNumber;

}
