package cn.com.duiba.bigdata.common.biz.service;

import cn.com.duiba.bigdata.common.biz.dto.KeyValueDto;
import cn.com.duiba.bigdata.common.biz.enums.TuiaDimensionEnum;
import cn.com.duiba.bigdata.common.biz.form.HoloQueryForm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Test {

    public static void main(String[] args) throws Exception {
        HoloQueryForm form = new HoloQueryForm();
        form.setStartTime("2024-08-05 00:00:00");
        form.setEndTime("2024-08-05 10:00:00");

        List<String> metricList = new ArrayList<>();
        metricList.add("LAUNCH_COUPON_PV");
//        metricList.add("COUPON_EFFECT_CLICK_PV");
        form.setMetricList(metricList);

        List<String> dimensionList = new ArrayList<>();
//        dimensionList.add("APP_ID");
        dimensionList.add("ADVERT_ID");
        dimensionList.add("ABTEST_PLAN_ID");
        dimensionList.add("ABTEST_GROUP_ID");
        form.setDimensionList(dimensionList);

        List<KeyValueDto> conditionList = new ArrayList<>();
        KeyValueDto dto1 = new KeyValueDto(TuiaDimensionEnum.ABTEST_PLAN_ID, 246);
        conditionList.add(dto1);
        KeyValueDto dto2 = new KeyValueDto(TuiaDimensionEnum.ABTEST_GROUP_ID, Arrays.asList("1", "2", "3", "5", "7", "9", "10"));
        conditionList.add(dto2);
        form.setConditionList(conditionList);

//        SortDto orderByMetric = new SortDto("APP_LEVEL", SortEnum.DESC.toString());
//        form.setOrderByMetric(orderByMetric);

//        form.setDataShowType(HologresShowTypeEnum.ONLY_HOUR.toString());

        form.setPageSize(50);
        form.setPageNumber(1);

//        List<String> dimList = new ArrayList<>();
//        dimList.add("ABTEST_PLAN_ID");
//        dimList.add("ABTEST_GROUP_ID");
//        dimList.add("APP_LEVEL");

        String sql = HoloSqlService.getQuerySql(form, dimensionList, 1, 1);
        System.out.println(sql);

    }
}
