/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public final class DateFormatUtil {
    private static ThreadLocal<SimpleDateFormat> sdf = new ThreadLocal();
    private static ThreadLocal<SimpleDateFormat> localeSdf = new ThreadLocal();
    private static final TimeZone timezone = TimeZone.getDefault();

    public static Date parse(String pattern, String strDate) throws ParseException {
        SimpleDateFormat lsdf = DateFormatUtil.getSdf();
        lsdf.setTimeZone(timezone);
        lsdf.applyPattern(pattern);
        return lsdf.parse(strDate);
    }

    public static long getTime(String strDate) throws Exception {
        Date dt = DateFormatUtil.parse("yyyy-MM-dd HH:mm:ss", strDate);
        return dt.getTime();
    }

    public static Date parse(Locale locale, String pattern, String strDate) throws ParseException {
        SimpleDateFormat lsdf = DateFormatUtil.getLocaleSdf();
        lsdf.setDateFormatSymbols(DateFormatSymbols.getInstance(locale));
        lsdf.setTimeZone(timezone);
        lsdf.applyPattern(pattern);
        return lsdf.parse(strDate);
    }

    public static String format(String pattern, Date date) {
        SimpleDateFormat lsdf = DateFormatUtil.getSdf();
        lsdf.setTimeZone(timezone);
        lsdf.applyPattern(pattern);
        return lsdf.format(date);
    }

    public static String timestamp2Date(String seconds, String format) {
        String time = "";
        if (StringUtils.isNotBlank((CharSequence)seconds) && StringUtils.isNotBlank((CharSequence)format)) {
            SimpleDateFormat lsdf = new SimpleDateFormat(format, Locale.US);
            time = lsdf.format(new Date(Long.valueOf(seconds + "000")));
        }
        return time;
    }

    public static String format(String pattern, String strDate) throws Exception {
        return DateFormatUtil.format(pattern, DateFormatUtil.parse("yyyy-MM-dd HH:mm:ss", strDate));
    }

    public static String format(Locale locale, String pattern, Date date) {
        SimpleDateFormat lsdf = DateFormatUtil.getLocaleSdf();
        lsdf.setDateFormatSymbols(DateFormatSymbols.getInstance(locale));
        lsdf.setTimeZone(timezone);
        lsdf.applyPattern(pattern);
        return lsdf.format(date);
    }

    public static String convertFromTo(String srcPattern, String dstPattern, String strDate) throws ParseException {
        SimpleDateFormat lsdf = DateFormatUtil.getSdf();
        lsdf.setTimeZone(timezone);
        lsdf.applyPattern(srcPattern);
        Date date = lsdf.parse(strDate);
        lsdf.setTimeZone(timezone);
        lsdf.applyPattern(dstPattern);
        return lsdf.format(date);
    }

    private DateFormatUtil() {
        throw new UnsupportedOperationException();
    }

    private static SimpleDateFormat getSdf() {
        SimpleDateFormat lsdf = sdf.get();
        if (lsdf != null) {
            return lsdf;
        }
        lsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        sdf.set(lsdf);
        return lsdf;
    }

    private static SimpleDateFormat getLocaleSdf() {
        SimpleDateFormat lsdf = localeSdf.get();
        if (lsdf != null) {
            return lsdf;
        }
        lsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        localeSdf.set(lsdf);
        return lsdf;
    }

    public static Long getNowDifferenceTime(String logTime, String pattern) throws ParseException {
        if (StringUtils.isBlank((CharSequence)logTime)) {
            return 0L;
        }
        return (System.currentTimeMillis() - DateFormatUtil.parse(pattern, logTime).getTime()) / 1000L;
    }
}

