/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.util.ExprUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelSetTransformUtil {
    private static final Logger log = LoggerFactory.getLogger(LabelSetTransformUtil.class);
    public static final String QUESTION_MARK = "?";

    public static void main(String[] args) {
        Expr expr1 = ExprUtils.parse((String)"(?010301 || ?010302 || ?010303 ) && ( ?010201 || ?010202 || ?010204)");
        Expr expr2 = ExprUtils.parse((String)"(?010303 ) && ( ?010201 )");
        Expr expr3 = ExprUtils.parse((String)"(?010303 && ?01040201 ) && ( ?010201 )");
        Expr expr4 = ExprUtils.parse((String)"(?010303 || ?01040201 ) && ( ?010201 )");
        Expr expr5 = ExprUtils.parse((String)"(?010303) && ( ?01040201 || ?010201 )");
        Expr expr6 = ExprUtils.parse((String)"(?010301 || ?020302 || ?030303 ) && ( ?040201 || ?050202 || ?060204)");
        Expr expr7 = ExprUtils.parse((String)"(?010301) || ( ?010201)");
        Expr expr8 = ExprUtils.parse((String)"(?010301) || ( ?010302)");
        Expr expr9 = ExprUtils.parse((String)"(?010301 || ?010303) || ( ?020302)");
        Expr expr10 = ExprUtils.parse((String)"(?020210001 || ?031102) && ( ?010101)");
        Expr expr11 = ExprUtils.parse((String)"(?020210001 && ?031102) || ( ?010101)");
        Expr expr12 = ExprUtils.parse((String)"(?020210001 || ?031102) || ( ?010101)");
        Expr expr13 = ExprUtils.parse((String)"(?020210001 && ?010101) || ( ?020210002 && ?010102)|| ?031102");
        Expr expr14 = ExprUtils.parse((String)"(?031001 && ?031105)");
        Expr expr15 = ExprUtils.parse((String)"(?031001 || ?031105 || ?031201 ) && ( ?040201 || ?050202 || ?060204)");
        Expr expr16 = ExprUtils.parse((String)"!(?031001 && ?031105 && ?041105)");
        Expr expr17 = ExprUtils.parse((String)"(?020210001 && ?031102) || !(?031001 || ?031105)");
        Expr expr18 = ExprUtils.parse((String)"(?020210001 || ?031102) && !(?031001 || ?031105)");
        Expr expr19 = ExprUtils.parse((String)"((?0108||?010401||?010402)||(?010501||?010502))&&!(?010904||?010905||?010906||?010903||?010902)");
        Expr expr = ExprUtils.parse((String)"(?0108)");
        DistributeLabelFilterRuleDTO distributeLabelFilterRuleDTO = LabelSetTransformUtil.distributiveLabelFilterRule(expr.toString());
        System.out.println(JSONObject.toJSONString((Object)distributeLabelFilterRuleDTO));
    }

    public static DistributeLabelFilterRuleDTO distributiveLabelFilterRule(String labelFilterRule) {
        if (StringUtils.isEmpty((String)labelFilterRule) || !labelFilterRule.contains(QUESTION_MARK)) {
            return null;
        }
        try {
            Expr expr = ExprUtils.parse((String)labelFilterRule);
            if (expr instanceof E_LogicalAnd) {
                return LabelSetTransformUtil.fetchDistributeLabelFilterRuleForAnd((E_LogicalAnd)expr);
            }
            if (expr instanceof E_LogicalOr) {
                return LabelSetTransformUtil.fetchDistributeLabelFilterRuleForOr((E_LogicalOr)expr);
            }
            if (expr instanceof E_LogicalNot) {
                return LabelSetTransformUtil.fetchDistributeLabelFilterRuleForNot((E_LogicalNot)expr);
            }
            if (expr instanceof ExprVar) {
                DistributeLabelFilterRuleDTO distributeLabelFilterRuleDTO = new DistributeLabelFilterRuleDTO();
                distributeLabelFilterRuleDTO.setNeedSplit(Boolean.FALSE);
                return distributeLabelFilterRuleDTO;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static List<String> fetchLabelComposeElements(String labelCompose) {
        if (StringUtils.isEmpty((String)labelCompose) || !labelCompose.contains(QUESTION_MARK)) {
            return null;
        }
        try {
            ArrayList elements = Lists.newArrayList();
            Expr expr = ExprUtils.parse((String)labelCompose);
            LabelSetTransformUtil.fetchElementFromLogical(expr, elements);
            return elements;
        }
        catch (Exception e) {
            log.warn("LabelSetTransformUtil.fetchLabelComposeElements labelCompose = {} error ={} ", (Object)labelCompose, (Object)e);
            return null;
        }
    }

    private static DistributeLabelFilterRuleDTO fetchDistributeLabelFilterRuleForNot(E_LogicalNot expr) {
        DistributeLabelFilterRuleDTO distributeLabelFilterRuleDTO = new DistributeLabelFilterRuleDTO();
        E_LogicalNot e_logicalNot = expr;
        Expr arg = e_logicalNot.getArg();
        StringBuilder sb = new StringBuilder();
        ArrayList elements = Lists.newArrayList();
        LabelSetTransformUtil.fetchElementFromLogical((Expr)expr, elements);
        if (arg instanceof E_LogicalAnd) {
            for (String element : elements) {
                sb.append("!( ?").append(element).append(" )").append(" || ");
            }
        } else if (arg instanceof E_LogicalOr) {
            for (String element : elements) {
                sb.append("!( ?").append(element).append(" )").append(" && ");
            }
        }
        String s = sb.toString();
        distributeLabelFilterRuleDTO.setFilters(Lists.newArrayList((Object[])new String[]{s.substring(0, s.length() - 4)}));
        distributeLabelFilterRuleDTO.setNeedSplit(Boolean.TRUE);
        return distributeLabelFilterRuleDTO;
    }

    private static DistributeLabelFilterRuleDTO fetchDistributeLabelFilterRuleForOr(E_LogicalOr expr) {
        DistributeLabelFilterRuleDTO distributeLabelFilterRuleDTO = new DistributeLabelFilterRuleDTO();
        E_LogicalOr e_logicalOr = expr;
        ArrayList elements = Lists.newArrayList();
        LabelSetTransformUtil.fetchClassElementFromLogical((Expr)e_logicalOr, elements);
        int leftNumOr = e_logicalOr.toString().split("\\|\\|").length;
        boolean notNeedDivide = false;
        if (elements.size() == leftNumOr) {
            notNeedDivide = true;
        } else {
            Expr arg1 = e_logicalOr.getArg1();
            Expr arg2 = e_logicalOr.getArg2();
            if (arg1 instanceof ExprVar && arg2 instanceof ExprVar) {
                notNeedDivide = LabelSetTransformUtil.getLabelClass(arg1.getVarName()).equalsIgnoreCase(LabelSetTransformUtil.getLabelClass(arg2.getVarName()));
            } else if (arg1 instanceof E_LogicalOr || arg2 instanceof E_LogicalOr) {
                ArrayList leftElements = Lists.newArrayList();
                LabelSetTransformUtil.fetchClassElementFromLogical(arg1, leftElements);
                boolean leftSameClassElemnt = leftElements.stream().distinct().count() == 1L;
                int leftSubNumOr = arg1.toString().split("\\|\\|").length;
                if (leftSameClassElemnt && leftElements.size() == leftSubNumOr) {
                    notNeedDivide = false;
                }
                ArrayList rightElements = Lists.newArrayList();
                LabelSetTransformUtil.fetchClassElementFromLogical(arg2, rightElements);
                boolean rightSameClassElemnt = rightElements.stream().distinct().count() == 1L;
                int rightSubNumOr = arg1.toString().split("\\|\\|").length;
                if (rightSameClassElemnt && rightElements.size() == rightSubNumOr) {
                    notNeedDivide = false;
                }
            } else if (arg1 instanceof E_LogicalNot || arg2 instanceof E_LogicalNot) {
                notNeedDivide = false;
            }
        }
        if (!notNeedDivide) {
            List<String> filterRule = LabelSetTransformUtil.distributiveFilterRule((Expr)expr);
            distributeLabelFilterRuleDTO.setFilters(filterRule);
            distributeLabelFilterRuleDTO.setNeedSplit(Boolean.TRUE);
        } else {
            distributeLabelFilterRuleDTO.setNeedSplit(Boolean.FALSE);
        }
        return distributeLabelFilterRuleDTO;
    }

    private static DistributeLabelFilterRuleDTO fetchDistributeLabelFilterRuleForAnd(E_LogicalAnd expr) {
        boolean notNeedDivide;
        DistributeLabelFilterRuleDTO distributeLabelFilterRuleDTO = new DistributeLabelFilterRuleDTO();
        E_LogicalAnd e_logicalAnd = expr;
        Expr arg1 = e_logicalAnd.getArg1();
        ArrayList leftElements = Lists.newArrayList();
        int leftNumOr = 0;
        if (arg1 instanceof E_LogicalOr) {
            LabelSetTransformUtil.fetchClassElementFromLogical(arg1, leftElements);
            leftNumOr = arg1.toString().split("\\|\\|").length;
        } else if (arg1 instanceof ExprVar) {
            leftElements.add(LabelSetTransformUtil.getLabelClass(arg1.getVarName()));
            leftNumOr = 1;
        }
        boolean leftClassElement = true;
        if (CollectionUtils.isNotEmpty((Collection)leftElements)) {
            leftClassElement = leftElements.stream().distinct().count() == 1L;
        }
        Expr arg2 = e_logicalAnd.getArg2();
        ArrayList rightElements = Lists.newArrayList();
        int rightNumOr = 0;
        if (arg2 instanceof E_LogicalOr) {
            LabelSetTransformUtil.fetchClassElementFromLogical(arg2, rightElements);
            rightNumOr = arg2.toString().split("\\|\\|").length;
        } else if (arg2 instanceof ExprVar) {
            rightElements.add(LabelSetTransformUtil.getLabelClass(arg2.getVarName()));
            rightNumOr = 1;
        }
        boolean rightClassElement = true;
        if (CollectionUtils.isNotEmpty((Collection)rightElements)) {
            rightClassElement = rightElements.stream().distinct().count() == 1L;
        }
        boolean bl = notNeedDivide = leftClassElement && leftElements.size() == leftNumOr && rightElements.size() == rightNumOr && rightClassElement;
        if (!notNeedDivide) {
            List<String> filterRule = LabelSetTransformUtil.distributiveFilterRule((Expr)expr);
            distributeLabelFilterRuleDTO.setFilters(filterRule);
            distributeLabelFilterRuleDTO.setNeedSplit(Boolean.TRUE);
        } else {
            distributeLabelFilterRuleDTO.setNeedSplit(Boolean.FALSE);
        }
        return distributeLabelFilterRuleDTO;
    }

    public static List<String> distributiveFilterRule(Expr expr) {
        ArrayList labelSet = Lists.newArrayList();
        try {
            if (expr instanceof E_LogicalAnd) {
                E_LogicalAnd e_logicalAnd = (E_LogicalAnd)expr;
                String opName = e_logicalAnd.getOpName();
                ArrayList left = Lists.newArrayList();
                LabelSetTransformUtil.concatStrForLogicalOr(e_logicalAnd.getArg1(), left);
                ArrayList right = Lists.newArrayList();
                LabelSetTransformUtil.concatStrForLogicalOr(e_logicalAnd.getArg2(), right);
                for (String l : left) {
                    for (String r : right) {
                        StringBuilder sb = new StringBuilder();
                        labelSet.add(sb.append("(").append(l).append(" ").append(opName).append(" ").append(r).append(")").toString());
                    }
                }
            } else if (expr instanceof E_LogicalOr) {
                E_LogicalOr e_logicalOr = (E_LogicalOr)expr;
                ArrayList left = Lists.newArrayList();
                LabelSetTransformUtil.concatStrForLogicalOr(e_logicalOr.getArg1(), left);
                ArrayList right = Lists.newArrayList();
                LabelSetTransformUtil.concatStrForLogicalOr(e_logicalOr.getArg2(), right);
                labelSet.addAll(left);
                labelSet.addAll(right);
            }
        }
        catch (Exception e) {
            log.warn("LabelSetTransformUtil.distributiveFilterRule labelFilterRule = {} error = {}", (Object)expr.toString(), (Object)e);
        }
        return labelSet;
    }

    public static String concatStrForLogicalOr(Expr expr, List<String> param) {
        if (expr instanceof ExprVar) {
            ExprVar ev = (ExprVar)expr;
            param.add(ev.toString());
        } else if (expr instanceof E_LogicalOr) {
            E_LogicalOr ssub1 = (E_LogicalOr)expr;
            ArrayList elements = Lists.newArrayList();
            LabelSetTransformUtil.fetchClassElementFromLogical((Expr)ssub1, elements);
            boolean leftSameClassElemnt = elements.stream().distinct().count() == 1L;
            int leftSubNumOr = ssub1.toString().split("\\|\\|").length;
            if (leftSameClassElemnt && elements.size() == leftSubNumOr) {
                param.add(ssub1.toString());
            } else {
                String s2;
                String s1 = LabelSetTransformUtil.concatStrForLogicalOr(ssub1.getArg1(), param);
                if (StringUtils.isNotEmpty((String)s1)) {
                    param.add(s1);
                }
                if (StringUtils.isNotEmpty((String)(s2 = LabelSetTransformUtil.concatStrForLogicalOr(ssub1.getArg2(), param)))) {
                    param.add(s2);
                }
            }
        } else if (expr instanceof E_LogicalAnd) {
            param.add(expr.toString());
        } else if (expr instanceof E_LogicalNot) {
            E_LogicalNot e_logicalNot = (E_LogicalNot)expr;
            Expr arg = e_logicalNot.getArg();
            StringBuilder sb = new StringBuilder();
            ArrayList elements = Lists.newArrayList();
            LabelSetTransformUtil.fetchElementFromLogical(expr, elements);
            if (arg instanceof E_LogicalAnd) {
                for (String element : elements) {
                    sb.append("!( ?").append(element).append(" )").append(" || ");
                }
            } else if (arg instanceof E_LogicalOr) {
                for (String element : elements) {
                    sb.append("!( ?").append(element).append(" )").append(" && ");
                }
            }
            String s = sb.toString();
            param.add(s.substring(0, s.length() - 4));
        }
        return null;
    }

    public static String fetchElementFromLogical(Expr expr, List<String> elements) {
        if (expr instanceof ExprVar) {
            ExprVar ev = (ExprVar)expr;
            elements.add(ev.getVarName());
        } else if (expr instanceof E_LogicalOr) {
            String s2;
            E_LogicalOr e_logicalOr = (E_LogicalOr)expr;
            String s1 = LabelSetTransformUtil.fetchElementFromLogical(e_logicalOr.getArg1(), elements);
            if (StringUtils.isNotEmpty((String)s1)) {
                elements.add(s1);
            }
            if (StringUtils.isNotEmpty((String)(s2 = LabelSetTransformUtil.fetchElementFromLogical(e_logicalOr.getArg2(), elements)))) {
                elements.add(s2);
            }
        } else if (expr instanceof E_LogicalAnd) {
            String s2;
            E_LogicalAnd e_logicalAnd = (E_LogicalAnd)expr;
            String s1 = LabelSetTransformUtil.fetchElementFromLogical(e_logicalAnd.getArg1(), elements);
            if (StringUtils.isNotEmpty((String)s1)) {
                elements.add(s1);
            }
            if (StringUtils.isNotEmpty((String)(s2 = LabelSetTransformUtil.fetchElementFromLogical(e_logicalAnd.getArg2(), elements)))) {
                elements.add(s2);
            }
        } else if (expr instanceof E_LogicalNot) {
            E_LogicalNot e_logicalNot = (E_LogicalNot)expr;
            List args = e_logicalNot.getArgs();
            for (Expr arg : args) {
                LabelSetTransformUtil.fetchElementFromLogical(arg, elements);
            }
        }
        return null;
    }

    private static String getLabelClass(String labelCode) {
        if (StringUtils.isEmpty((String)labelCode)) {
            return null;
        }
        if (labelCode.startsWith("03")) {
            return "0300";
        }
        if (labelCode.startsWith("04")) {
            return "0400";
        }
        if (labelCode.startsWith("05")) {
            return "0500";
        }
        if (labelCode.startsWith("09")) {
            return "0900";
        }
        return labelCode.substring(0, 4);
    }

    public static String fetchClassElementFromLogical(Expr expr, List<String> elements) {
        if (expr instanceof ExprVar) {
            ExprVar ev = (ExprVar)expr;
            elements.add(LabelSetTransformUtil.getLabelClass(ev.getVarName()));
        } else if (expr instanceof E_LogicalOr) {
            String s2;
            E_LogicalOr e_logicalOr = (E_LogicalOr)expr;
            String s1 = LabelSetTransformUtil.fetchClassElementFromLogical(e_logicalOr.getArg1(), elements);
            if (StringUtils.isNotEmpty((String)s1)) {
                elements.add(LabelSetTransformUtil.getLabelClass(s1));
            }
            if (StringUtils.isNotEmpty((String)(s2 = LabelSetTransformUtil.fetchClassElementFromLogical(e_logicalOr.getArg2(), elements)))) {
                elements.add(LabelSetTransformUtil.getLabelClass(s2));
            }
        } else if (expr instanceof E_LogicalAnd) {
            String s2;
            E_LogicalAnd e_logicalAnd = (E_LogicalAnd)expr;
            String s1 = LabelSetTransformUtil.fetchClassElementFromLogical(e_logicalAnd.getArg1(), elements);
            if (StringUtils.isNotEmpty((String)s1)) {
                elements.add(LabelSetTransformUtil.getLabelClass(s1));
            }
            if (StringUtils.isNotEmpty((String)(s2 = LabelSetTransformUtil.fetchClassElementFromLogical(e_logicalAnd.getArg2(), elements)))) {
                elements.add(LabelSetTransformUtil.getLabelClass(s2));
            }
        }
        return null;
    }

    public static class DistributeLabelFilterRuleDTO {
        private List<String> filters;
        private Boolean needSplit;

        public List<String> getFilters() {
            return this.filters;
        }

        public Boolean getNeedSplit() {
            return this.needSplit;
        }

        public void setFilters(List<String> filters) {
            this.filters = filters;
        }

        public void setNeedSplit(Boolean needSplit) {
            this.needSplit = needSplit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DistributeLabelFilterRuleDTO)) {
                return false;
            }
            DistributeLabelFilterRuleDTO other = (DistributeLabelFilterRuleDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$needSplit = this.getNeedSplit();
            Boolean other$needSplit = other.getNeedSplit();
            if (this$needSplit == null ? other$needSplit != null : !((Object)this$needSplit).equals(other$needSplit)) {
                return false;
            }
            List<String> this$filters = this.getFilters();
            List<String> other$filters = other.getFilters();
            return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DistributeLabelFilterRuleDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $needSplit = this.getNeedSplit();
            result = result * 59 + ($needSplit == null ? 43 : ((Object)$needSplit).hashCode());
            List<String> $filters = this.getFilters();
            result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
            return result;
        }

        public String toString() {
            return "LabelSetTransformUtil.DistributeLabelFilterRuleDTO(filters=" + this.getFilters() + ", needSplit=" + this.getNeedSplit() + ")";
        }
    }
}

