package cn.com.duiba.bigdata.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 广告位活动推荐
 * @author xugf 2019-09-02
 */
@AdvancedFeignClient
public interface RemoteSlotActivityRecommendService {

    /**
     * 获取推荐的活动id
     * @param slotId 广告位id
     * @return 活动id
     */
    Long getActivityId(Long slotId);

    /**
     * 移除本次海选池中的活动id
     * @param slotId 广告位id
     * @param activityId 活动id
     * @return true 表示移除成功 false 表示移除失败
     */
    Boolean removeActivityId(Long slotId, Long activityId);
}
