package cn.com.duibabiz.component.filters.bloom.url.interceptor;

import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duiba.wolf.entity.Pair;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessFilter;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessLocal;
import cn.com.duibabiz.component.filters.bloom.url.factory.PathMapperFactory;
import cn.com.duibabiz.component.filters.bloom.url.path.PathMapping;
import cn.com.duibabiz.component.filters.bloom.url.path.PathParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * url拦截器
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/4/19 11:16
 */
public class PathInterceptInterceptor implements HandlerInterceptor {
    public static final Logger LOGGER = LoggerFactory.getLogger(PathInterceptInterceptor.class);

    @Resource
    private UrlSerialAccessFilter urlSerialAccessFilter;
    @Resource
    private PathMapperFactory pathMapperFactory;

    /**
     * 预先拦截
     */
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Long cid = RequestLocal.getCid();
        String uri = request.getRequestURI();
        try {
            PathMapping pathMapping = pathMapperFactory.getHandler(uri);
            if (pathMapping != null) {
                PathParser interceptPathParser = pathMapping.getInterceptPathParser();
                PathParser recordPathParser = pathMapping.getRecordPathParser();


                Pair<Boolean, String> pair = urlSerialAccessFilter.hasRecord(interceptPathParser, cid, recordPathParser.getPath());
                // 保存到当前线程变量
                UrlSerialAccessLocal.set(pair);

            } else {
                LOGGER.info("urlSerialAccessService,intercept,pathMapping is NULL,cid={},path={},", cid, uri);
            }
        } catch (Exception e) {
            LOGGER.warn("urlSerialAccessService,intercept,exception,cid={},path={}", cid, uri, e);
        }

        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        UrlSerialAccessLocal.clear();
    }
}
