/**
 * Project Name:access-activity-web
 * File Name:PluginDomainCrossUtils.java
 * Package Name:com.duiba.activity.service.biz.util
 * Date:2016年11月4日下午5:39:01
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.biz.tool.duiba.cros;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * cros跨域
 */
public class CrossDomainUtils {

    private CrossDomainUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void crossDomain(HttpServletRequest request,HttpServletResponse response){
        crossDomain(request, response, null);
    }
    /**
     * 跨域设置
     * @param request
     * @param response
     */
    public static void crossDomain(HttpServletRequest request,HttpServletResponse response,String systemDomain){
        //先判断有没有Origin,再从mapping systemDomain中取
        String domain = request.getHeader("Origin");
        if(domain != null && (domain.endsWith("duiba.com.cn") || domain.endsWith("tuistone.com"))) {
            // 设置允许跨域
            response.setHeader(CookieDefine.ACCESS_CONTROL_ALLOW_ORIGIN, UrlUtils.addScheme(domain, request));
            setCrosResponseHeader(response);
            return;
        }

        if(systemDomain != null && (systemDomain.endsWith("duiba.com.cn") || systemDomain.endsWith("tuistone.com"))){
            // 设置允许跨域
            response.setHeader(CookieDefine.ACCESS_CONTROL_ALLOW_ORIGIN, UrlUtils.addScheme(systemDomain, request));
            setCrosResponseHeader(response);
            return;
        }
    }

    private static void setCrosResponseHeader(HttpServletResponse response) {
        response.setHeader(CookieDefine.ACCESS_CONTROL_ALLOW_METHODS, "POST,GET");
        response.setHeader(CookieDefine.ACCESS_CONTROL_MAX_AGE, "3600");
        response.setHeader(CookieDefine.ACCESS_CONTROL_ALLOW_HEADERS, "x-requested-with");
        response.setHeader(CookieDefine.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
    }
}

