package cn.com.duibabiz.component.versioncheck;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duibabiz.tools.BizToolJarVersionUtils;
import cn.com.duibaboot.ext.autoconfigure.DuibaBootVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

/**
 * Created by sunchangji on 2018/11/2.
 */
@Configuration
@ConditionalOnClass({MainContextRefreshedEvent.class, SpringEnvironmentUtils.class})
@EnableConfigurationProperties(BizVersionCheckProperties.class)
public class JarVersionCheckConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(JarVersionCheckConfiguration.class);
    private static final String EXIT_MSG = "启动失败,应用关闭......";

    @Autowired
    private BizVersionCheckProperties bizVersionCheckProperties;

    @EventListener(MainContextRefreshedEvent.class)
    public void checkVersion() {
        //生产环境不做检测
        if (SpringEnvironmentUtils.isProdEnv()) {
            return;
        }
        String bizToolVersion = BizToolVersion.getVersion();
        if (bizToolVersion == null) {
            throw new IllegalArgumentException("未检测到biz-tool版本号,请联系@孙长纪 进行排查");
        }
        String bizToolBaseVersion = bizVersionCheckProperties.getBiztool();
        Boolean adopt = BizToolJarVersionUtils.isJarVersionEqualOrGreaterThan(bizToolVersion, bizToolBaseVersion);
        if (adopt == null) {
            LOG.error("检测到项目当前引入biz-tool版本:{},版本定义不符合要求,请升至:{}或以上", bizToolVersion, bizToolBaseVersion);
            LOG.error(EXIT_MSG);
            System.exit(1);
        }
        if (!adopt) {
            LOG.error("检测到项目当前引入biz-tool版本:{}过低,请升至:{}或以上", bizToolVersion, bizToolBaseVersion);
            LOG.error(EXIT_MSG);
            System.exit(1);
        }
        String duibaExtVersion = DuibaBootVersion.getVersion();
        if (duibaExtVersion == null) {
            LOG.warn("未检测到duiba-boot-ext版本号,请联系@孙长纪 排查");
            return;
        }
        String duibaBootBaseVersion = bizVersionCheckProperties.getDuibaext();
        adopt = BizToolJarVersionUtils.isJarVersionEqualOrGreaterThan(duibaExtVersion, duibaBootBaseVersion);
        if (adopt == null) {
            throw new IllegalArgumentException("检测到项目当前引入duiba-boot-ext版本:" + duibaExtVersion + ",版本定义不符合要求,请确保版本不低于:" + duibaBootBaseVersion);
        }
        if (!adopt) {
            LOG.error("检测到项目当前引入duiba-boot-ext版本:{}过低,请升至:{}或以上", duibaExtVersion, duibaBootBaseVersion);
            LOG.error(EXIT_MSG);
            System.exit(1);
        }
    }
}
