package cn.com.duibabiz.component.filters.bloom.url.interceptor;

import cn.com.duibabiz.component.filters.bloom.url.factory.PathMapperFactory;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import javax.annotation.Resource;
import java.util.Set;

/**
 * 延迟注册，控制拦截顺序
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/4/19 17:48
 */
@Configuration
public class PathMvcConfig extends WebMvcConfigurerAdapter {
    public static final Logger LOGGER = LoggerFactory.getLogger(PathMvcConfig.class);

    @Resource
    private PathInterceptInterceptor pathInterceptInterceptor;
    @Resource
    private PathRecordInterceptor pathRecordInterceptor;
    @Resource
    private PathMapperFactory pathMapperFactory;

    private static void registryPathInterceptor(InterceptorRegistry registry,
                                                HandlerInterceptor handlerInterceptor,
                                                Set<String> paths) {
        if (CollectionUtils.isNotEmpty(paths)) {
            registry.addInterceptor(handlerInterceptor)
                    .addPathPatterns(paths.toArray(new String[0]));

            LOGGER.info("addInterceptors success,paths={}", JSON.toJSONString(paths));
        }
    }

    /**
     * {@inheritDoc}
     * <p>This implementation is empty.
     *
     * @param registry
     */
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        super.addInterceptors(registry);

        // 注册记录器
        registryPathInterceptor(registry, pathRecordInterceptor, pathMapperFactory.getRecordPaths());

        // 注册拦截器
        registryPathInterceptor(registry, pathInterceptInterceptor, pathMapperFactory.getKeySet());
    }

}
