package cn.com.duiba.biz.tool.duiba.util;

import java.util.Objects;

import com.alibaba.fastjson.JSONObject;

/**
 * ClassName:DuibaHdtoolUtil<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: DuibaHdtoolDto 中静态变量 及静态方法
 *
 * @date 创建时间：2018/4/17  20:14
 * @since JDK 1.8
 **/
public class DuibaHdtoolUtil {
    private DuibaHdtoolUtil(){
        //空构造方法
    }
    public static final int STATUS_NOCOMPLETE = 0; // 数据不完整
    public static final int STATUS_OPEN = 1; // 开启且可见
    public static final int STATUS_CLOSE_SHOW = 2; // 关闭且可见
    public static final int STATUS_CLOSE = 3; // 关闭不可见
    public static final int STATUS_CLOSE_READY_ON = 4; // 关闭不可见，即将自动上架
    public static final String LIMITTYPEFOREVER = "forever"; // 永久
    public static final String LIMITTYPEEVERYDAY = "everyday"; // 每天
    //SWITCHES 开关
    public static final int SWITCHES_DIRECT = 0;//定向发放
    public static final int SWITCHES_DEV_BLACKLIST = 1;//黑名单
    public static final int SWITCHES_FREE_RULE = 2;// 免费次数使用的活动规则
    public static final int SWITCHES_NEW = 3;//判断是否是新添加的活动-与管理员端保持一样用3,新添加活动大奖默认开启库存预分配功能
    //public static final int SWITCHES_NEW_HDTOOL = 4;//判断是否是新的活动工具
    public static final int ANTICHEAT_LIMIT_RULE = 5; // 开启直充类奖品防刷
    public static final int SWITCHES_NEW_ABTEST = 6;//活动工具是否开启 ab test
    public static final int SWITCHES_NEW_OPEN_MUTLI_PRIZE_LIMIT = 7;//开启多奖项限制
    public static final int SWITCHES_PRIZES_GRANT_LIMIT = 8;//奖品发放限制
    public static final int SWITCHES_PRIZES_GUESS = 9;//竞猜是否开奖
    public static final int SWITCHES_ACTIVITY_GROUP = 10; //是否在活动组
    public static final int SWITCHES_DIRECT_SEND_COUPON = 11; //是否直接出券
    /** 奖项中是否包含集卡红包 */
    public static final int SWITCHES_HAS_BONUS_OPTIONS = 12;
    /**
     * 是否开启邀请码规则
     */
    public static final int SWITCHES_INVITATION_CODE_RULE = 13;
    public static final String TYPE_CUSTOM_ACTION = "custom";//自定义活动工具
    public static final String EXT_JSON_KEY_MUTLI_PRIZE_LIMIT_COUNT = "mutliPrizeLimitCount";//extendJson扩展json字段key定义：多奖项限制次数
    public static final String EXT_JSON_KEY_MUTLI_PRIZE_LIMIT_IDS = "mutliPrizeLimitIds";//extendJson扩展json字段key定义：多奖项限制id列表
    public static final String EXT_JSON_KEY_MULTI_PRIZE_LIMIT_TYPE = "multiPrizeLimitType";// extendJson扩展json字段key定义：多奖项限制次数周期类型：1，永久；2，每日；3，自定义周期
    public static final String EXT_JSON_KEY_MULTI_PRIZE_LIMIT_DAYS = "multiPrizeLimitDays";// extendJson扩展json字段key定义：多奖项限制次数自定义周期天数
    public static final String EXT_JSON_KEY_THROUGH_MODE = "through_mode";//extendJson扩展json字段key定义：闯关模式
    public static final String EXT_JSON_KEY_THROUGH_NUM = "through_num";//extendJson扩展json字段key定义：关卡数
    public static final String EXT_JSON_KEY_PRIZES_GRANT_LIMIT_DAYS = "prizesGrantLimitDays";//extendJson扩展json字段key定义：奖品兑换限制天数(旧版)
    public static final String EXT_JSON_KEY_PRIZES_GRANT_LIMIT_NEW_DAYS = "prizesGrantLimitNewDays";//extendJson扩展json字段key定义：奖品兑换限制天数(新版)
    public static final String EXT_JSON_KEY_PRIZES_GRANT_LIMIT_NUMS = "prizesGrantLimitNum";//extendJson扩展json字段key定义：各奖品兑换限制数量
    public static final String EXT_JSON_KEY_ANTI_CHEAT_EXCHANGE_TYPE = "anticheatExchangeType";//extendJson扩展json字段key定义：直冲类奖项防刷类型 0：每日一次  1：永久一次
    public static final String GME_EXT_JSON_KEY_OPENRANK="openRank";//游戏排行榜
    public static final String GME_EXT_JSON_KEY_SCOREUNIT="scoreUnit";//分数验证
    public static final String GME_EXT_JSON_KEY_INTERNALPROP="internalProp";//是否开启内购道具
    public static final String GME_EXT_JSON_KEY_REVIVE="revive";//是否可以复活
    public static final String GME_EXT_JSON_KEY_REVIVECOUNT="reviveCount";//复活次数
    public static final String GME_EXT_JSON_KEY_REVIVECREDITS="reviveCredits";//复活所需积分
    public static final String GME_EXT_JSON_KEY_INTERFACELIMIT="interfaceLimit";//分数验证 次数

    public static final int THROUGH_MODE = 1;//闯关模式
    public static final int THROUGH_MODE_FREE = 2;//自由模式
    public static final int THROUGH_MODE_CYCLE = 3;//单关循环

    /**
     * 获取最新发奖限制天数
     * 兼容旧版本1每日,7自然周,30自然月
     * 改成天数：>0数字；自然周：-1；自然月：-2
     * 之前没设置好，流下了悔恨的泪水，过度后可删除
     * @param jsonObject
     * @return
     */
    public static Integer changeLimitDays2New (JSONObject jsonObject){
        if(jsonObject.get(EXT_JSON_KEY_PRIZES_GRANT_LIMIT_NEW_DAYS)!=null){
            return jsonObject.getInteger(EXT_JSON_KEY_PRIZES_GRANT_LIMIT_NEW_DAYS);
        }

        //旧版发奖限制天数(1每日,7每周,30每月)
        Integer prizesGrantLimitDays = jsonObject.getInteger(EXT_JSON_KEY_PRIZES_GRANT_LIMIT_DAYS);
        if(Objects.equals(prizesGrantLimitDays,7)){
            return -1;
        }else if(Objects.equals(prizesGrantLimitDays,30)){
            return -2;
        }
        return prizesGrantLimitDays;
    }
}
