/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.oss.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duibabiz.component.oss.OssAppendEntity;
import cn.com.duibabiz.component.oss.OssClient;
import cn.com.duibabiz.component.oss.OssDownloadEntity;
import cn.com.duibabiz.component.oss.OssProperties;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OssClientImpl
implements OssClient {
    private static final Logger logger = LoggerFactory.getLogger(OssClientImpl.class);
    @Autowired
    private OssProperties ossProperties;
    @Resource
    @CanAccessInsideNetwork
    private CloseableHttpClient httpClient;

    @PostConstruct
    private void checkEndPoint() throws BizException {
        if (StringUtils.isBlank((CharSequence)this.ossProperties.getEndPoint())) {
            logger.warn("\u8bf7\u68c0\u67e5\u8d44\u6e90\u5316Oss-api\u8d44\u6e90\u5316\u914d\u7f6e");
        }
    }

    @Override
    public String upload(String bucketName, String path, File file) throws BizException {
        return this.upload(bucketName, path, file, null, null, null);
    }

    @Override
    public String upload(String bucketName, String path, String base64) throws BizException {
        return this.upload(bucketName, path, null, base64, null, null);
    }

    @Override
    public String upload(String bucketName, String path, InputStream inputStream, String fileName) throws BizException {
        if (StringUtils.isBlank((CharSequence)fileName) || inputStream == null) {
            throw new BizException("\u6587\u4ef6\u540d\u6216\u8005\u6d41\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] split = fileName.split("\\.");
        if (split.length != 2) {
            throw new BizException("\u6587\u4ef6\u540d\u683c\u5f0f\u9519\u8bef");
        }
        return this.upload(bucketName, path, null, null, inputStream, fileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OssAppendEntity appendUpload(String bucketName, String path, InputStream inputStream, String fileName, Long position) throws BizException {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossProperties.getBucketName();
        }
        if (inputStream == null) throw new BizException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        if (position == null) throw new BizException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new BizException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (position != 0L && StringUtils.isBlank((CharSequence)path)) {
            throw new BizException("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] split = fileName.split("\\.");
        if (split.length != 2) {
            throw new BizException("\u6587\u4ef6\u540d\u683c\u5f0f\u9519\u8bef");
        }
        HttpPost httpPost = new HttpPost(this.ossProperties.getAppendUploadUrl());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addPart("bucketName", (ContentBody)new StringBody(bucketName, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
        builder.addPart("position", (ContentBody)new StringBody(position.toString(), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
        builder.addBinaryBody("file", inputStream, ContentType.DEFAULT_BINARY, fileName);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            builder.addPart("path", (ContentBody)new StringBody(path, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
        }
        HttpEntity reqEntity = builder.build();
        httpPost.setEntity(reqEntity);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            JSONObject jsonObject = JSON.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()));
            if (jsonObject.getBoolean("success").booleanValue()) {
                OssAppendEntity ossAppendEntity = (OssAppendEntity)JSON.parseObject((String)jsonObject.getJSONObject("data").toJSONString(), OssAppendEntity.class);
                return ossAppendEntity;
            }
            throw new BizException(jsonObject.getString("message"));
        }
        catch (BizException e) {
            logger.warn("\u4e0a\u4f20\u5f02\u5e38 bucketName={},path={},fileName={}", new Object[]{bucketName, path, fileName, e});
            throw e;
        }
        catch (Exception e) {
            logger.error("\u7cfb\u7edf\u5f02\u5e38 bucketName={},path={},fileName={}", new Object[]{bucketName, path, fileName, e});
            throw new BizException("\u8ffd\u52a0\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @Override
    public OssDownloadEntity download(String bucketName, String path) throws BizException {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossProperties.getBucketName();
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BizException("\u6587\u4ef6\u8def\u5f84 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String downloadUrl = this.ossProperties.getDownloadUrl();
        downloadUrl = downloadUrl.contains("?") ? downloadUrl + "bucketName=%s&objectName=%s" : downloadUrl + "?bucketName=%s&objectName=%s";
        String getUrl = String.format(downloadUrl, bucketName, path);
        return this.httpDownload(getUrl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean fileExist(String bucketName, String path) throws BizException {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossProperties.getBucketName();
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BizException("\u6587\u4ef6\u8def\u5f84 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String existUrl = this.ossProperties.getExistUrl();
        existUrl = existUrl.contains("?") ? existUrl + "bucketName=%s&url=%s" : existUrl + "?bucketName=%s&url=%s";
        HttpGet get = new HttpGet(String.format(existUrl, bucketName, path));
        get.setHeader("Accept-Language", "zh-cn,zh;q=0.5");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
            Integer statusCode = response.getStatusLine().getStatusCode();
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            if (statusCode == 200) {
                JSONObject jsonObject = JSON.parseObject((String)body);
                Boolean bl = jsonObject.getBoolean("success");
                return bl;
            }
            throw new BizException(String.format("http\u72b6\u6001\u7801= %s body= %s ", statusCode.toString(), body));
        }
        catch (Exception e) {
            logger.error("\u5224\u65ad\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9519\u8bef bucketName={} path={}", new Object[]{bucketName, path, e});
            throw new BizException("\u5224\u65ad\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9519\u8bef");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String sceneDetection(String url, List<String> scenes) throws Exception {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new BizException("\u68c0\u6d4b\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (scenes == null) throw new BizException("\u68c0\u6d4b\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a");
        if (scenes.size() == 0) {
            throw new BizException("\u68c0\u6d4b\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuffer sb = new StringBuffer();
        scenes.forEach(s -> sb.append(s + ","));
        sb.deleteCharAt(sb.length() - 1);
        String str = sb.toString();
        String sceneDetectionUrl = this.ossProperties.getSceneDetectionUrl();
        sceneDetectionUrl = sceneDetectionUrl.contains("?") ? sceneDetectionUrl + "url=%s&scenes=%s" : sceneDetectionUrl + "?url=%s&scenes=%s";
        HttpPost post = new HttpPost(String.format(sceneDetectionUrl, url, str));
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
            Integer statusCode = response.getStatusLine().getStatusCode();
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            if (statusCode == 200) {
                JSONObject jsonObject = JSON.parseObject((String)body);
                if (jsonObject.getBoolean("success").booleanValue()) {
                    String string = null;
                    return string;
                }
                String string = jsonObject.getString("message");
                return string;
            }
            throw new BizException(String.format("http\u72b6\u6001\u7801= %s body= %s ", statusCode.toString(), body));
        }
        catch (Exception e) {
            logger.error("\u56fe\u7247\u68c0\u6d4b\u9519\u8bef url={} scenes={}", new Object[]{url, scenes, e});
            throw new BizException("\u56fe\u7247\u68c0\u6d4b\u9519\u8bef");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OssDownloadEntity httpDownload(String url) throws BizException {
        OssDownloadEntity ossDownloadEntity2 = new OssDownloadEntity();
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept-Language", "zh-cn,zh;q=0.5");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
            if (response.getStatusLine().getStatusCode() != 200) throw new BizException("\u4e0b\u8f7d\u9519\u8bef");
            HttpEntity entity = response.getEntity();
            ossDownloadEntity2.setInputStream(new ByteArrayInputStream(this.inputStream2byte(entity.getContent())));
            ossDownloadEntity2.setContentType(entity.getContentType().getValue());
            OssDownloadEntity ossDownloadEntity = ossDownloadEntity2;
            return ossDownloadEntity;
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u9519\u8bef url={}", (Object)url, (Object)e);
        }
        throw new BizException("\u4e0b\u8f7d\u9519\u8bef");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String upload(String bucketName, String path, File file, String base64, InputStream in, String fileName) throws BizException {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossProperties.getBucketName();
        }
        try {
            HttpPost httpPost = new HttpPost(this.ossProperties.getUploadUrl());
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addPart("bucketName", (ContentBody)new StringBody(bucketName, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
            if (StringUtils.isNotBlank((CharSequence)path)) {
                builder.addPart("path", (ContentBody)new StringBody(path, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
            }
            if (file != null) {
                builder.addBinaryBody("file", (InputStream)new FileInputStream(file), ContentType.create((String)new MimetypesFileTypeMap().getContentType(file)), file.getName());
            }
            if (in != null && StringUtils.isNotBlank((CharSequence)fileName)) {
                builder.addBinaryBody("file", in, ContentType.create((String)new MimetypesFileTypeMap().getContentType(fileName)), fileName);
            }
            if (StringUtils.isNotBlank((CharSequence)base64)) {
                builder.addPart("base64", (ContentBody)new StringBody(base64, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
            }
            HttpEntity reqEntity = builder.build();
            httpPost.setEntity(reqEntity);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new BizException("\u7cfb\u7edf\u5f02\u5e38");
                }
                JSONObject jsonObject = JSON.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()));
                Boolean success = jsonObject.getBoolean("success");
                if (!success.booleanValue()) {
                    throw new BizException(jsonObject.getString("message"));
                }
                String string = jsonObject.getString("data");
                return string;
            }
        }
        catch (BizException e) {
            logger.warn("\u4e0a\u4f20\u5f02\u5e38 bucketName={},path={},fileName={}", new Object[]{bucketName, path, fileName, e});
            throw e;
        }
        catch (Exception e) {
            logger.error("\u7cfb\u7edf\u5f02\u5e38 bucketName={},path={},fileName={}", new Object[]{bucketName, path, file == null ? fileName : file.getName(), e});
            throw new BizException("\u7cfb\u7edf\u5f02\u5e38");
        }
    }

    public byte[] inputStream2byte(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        while ((rc = inputStream.read(buff, 0, 100)) > 0) {
            byteArrayOutputStream.write(buff, 0, rc);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

