/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.openapi.service.api.enums;

import lombok.Getter;

/**
 * 文档类型，后面根据是否要进行文档分类来设置文档类型
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/5 3:50 下午
 **/
@Getter
public enum OpenDocumentTypeEnum {
    /**
     * 文档类型
     */
    PUBLIC(1, "公共"),
    ;

    private Integer value;

    private String desc;

    OpenDocumentTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (OpenDocumentTypeEnum item : OpenDocumentTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static OpenDocumentTypeEnum valueOf(Integer value) {
        for (OpenDocumentTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
