package cn.com.duiba.cloud.duiba.openapi.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.dto.OpenApiConfigDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.param.ApiRegisterParam;
import cn.com.duiba.cloud.duiba.openapi.service.api.param.ApiQueryParam;
import cn.com.duiba.cloud.duiba.openapi.service.api.param.ApiUpdateParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 接口配置服务
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/24 10:44 上午
 **/
@AdvancedFeignClient("duiba-openapi-service")
public interface RemoteApiConfigService {

    /**
     * 更加apiPath获取该接口配置信息
     *
     * @param apiPath
     * @return
     */
    OpenApiConfigDTO getApiConfigByPath(String apiPath);


    /**
     * 接口注册, 不需手动调用，请通过注解进行注册
     * @param registerParam
     * @return
     * @throws BizException
     */
    Boolean register(ApiRegisterParam registerParam) throws BizException;


    /**
     * 查询api配置
     * @param param
     * @return
     */
    PageResponse<OpenApiConfigDTO> queryApiConfig(ApiQueryParam param);

    /**
     * 更新api配置
     * @param param
     * @return
     */
    Boolean updateApiConfig(ApiUpdateParam param);

    OpenApiConfigDTO getApiConfigById(Long id);
}
