package cn.com.duiba.cloud.duiba.openapi.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.dto.OpenDocumentDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.param.DocumentQueryParam;
import cn.com.duiba.cloud.duiba.openapi.service.api.param.DocumentSaveParam;
import cn.com.duiba.cloud.duiba.openapi.service.api.param.DocumentUpdateParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/3 3:34 下午
 **/
@AdvancedFeignClient("duiba-openapi-service")
public interface RemoteDocumentService {
    /**
     * 查询限流配置
     *
     * @param param
     * @return
     */
    PageResponse<OpenDocumentDTO> queryDocumentForPage(DocumentQueryParam param);

    /**
     * 添加限流配置
     *
     * @param param
     * @return
     */
    Boolean addDocument(DocumentSaveParam param);

    /**
     * 更新限流配置
     *
     * @param param
     * @return
     */
    Boolean updateDocument(DocumentUpdateParam param);

    /**
     * 查询document信息
     *
     * @param id
     * @return
     */
    OpenDocumentDTO getDocumentDetailById(Long id);
}
