package cn.com.duiba.cloud.duiba.openapi.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.dto.FlowLimitConfigDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.param.FLowLimitQueryParam;
import cn.com.duiba.cloud.duiba.openapi.service.api.param.FLowLimitSaveParam;
import cn.com.duiba.cloud.duiba.openapi.service.api.param.FLowLimitUpdateParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/3 3:34 下午
 **/
@AdvancedFeignClient("duiba-openapi-service")
public interface RemoteFlowLimitService {
    /**
     * 查询限流配置
     *
     * @param param
     * @return
     */
    PageResponse<FlowLimitConfigDTO> queryFlowLimitConfig(FLowLimitQueryParam param);


    /**
     * 查询配置 by apiPath+appKey
     * @param param
     * @return
     */
    FlowLimitConfigDTO selectFlowLimitConfig(FLowLimitQueryParam param);

    /**
     * 添加限流配置
     * @param param
     * @return
     */
    Boolean addLimitConfig(FLowLimitSaveParam param);

    /**
     * 更新限流配置
     * @param param
     * @return
     */
    Boolean updateLimitConfig(FLowLimitUpdateParam param);

    PageResponse<FlowLimitConfigDTO> queryLimitConfigForPage(FLowLimitQueryParam param);
}
