package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto;

import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.enums.ActivityType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 扣积分入参
 * @author sunyan
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class CreditsRequestDTO extends RequestBaseDTO implements Serializable {
    private static final long serialVersionUID = -7878837759754241428L;
    /**
     * 积分变动发生时间戳
     */
    private Long changeTime;
    /**
     * 扣减积分原因
     */
    private String description;
    /**
     * 共计变动积分
     */
    private Long credits;
    /**
     * 活动订单号
     */
    private String activityOrderNum;
    /**
     * 活动/营销类型
     */
    private ActivityType activityType;
    /**
     * 活动/营销id
     */
    private String activityId;
    /**
     * 活动/营销名称
     */
    private String activityName;
    /**
     * 商品主订单号
     */
    private String orderNum;



}
