package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * @author sunyan
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RequestBaseDTO implements Serializable {

    private static final long serialVersionUID = 6579000080665829632L;
    /**
     * 外部用户id
     */
    private String uid;
    /**
     * appKey
     */
    private String appKey;
    /**
     * appSecret
     */
    private String appSecret;
    /**
     * 请求url
     */
    private String httpUrl;
    /**
     * 扩展参数
     */
    private Map<String, String> extParams;
    /**
     * 开发者回传参数
     */
    private String transfer;
    /**
     * mq回调topic
     */
    private String callbackTopic;
    /**
     * mq回调tag
     */
    private String callbackTag;
    /**
     * mq回调key
     */
    private String callbackKey;
}
