package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto;

import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.enums.HttpRequestResultType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author sunyan
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ResponseBaseDTO implements Serializable {
    /**
     * http消息请求完成:扣成功
     */
    public static final int CODE_SUCCESS = 1;
    /**
     * http消息请求完成:消息解析失败
     */
    public static final int CODE_PARSE_JSON_FAIL = 2;
    /**
     * http消息请求完成:其他失败
     */
    public static final int CODE_NORMAL_FAIL = 3;

    private static final long serialVersionUID = 3380830335718995817L;
    /**
     * 请求是否成功标志，1表示成功，2，3失败
     */
    private int code;
    /**
     * 出错原因
     */
    private String errorMessage;
    /**
     * 回调类型
     */
    private HttpRequestResultType resultType;

}
