package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.CreditsRequestDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.NotifyRequestDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.VirtualCallbackDTO;
import cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.dto.VirtualRequestDTO;

/**
 * 第三方交互接口（扣/加积分，通知等）
 * @author sunyan
 */
@AdvancedFeignClient("duiba-openapi-service")
public interface RemoteThirdpartyService {

    /**
     * 扣积分
     * @param creditsRequestDTO
     * @return
     */
    Boolean subCredits(CreditsRequestDTO creditsRequestDTO);

    /**
     * 加积分
     * @param creditsRequestDTO
     * @return
     */
    Boolean addCredits(CreditsRequestDTO creditsRequestDTO);

    /**
     * 充值下单
     * @param virtualRequestDTO
     * @return
     */
    Boolean submitVirtual(VirtualRequestDTO virtualRequestDTO);

    /**
     * 结果通知
     * @param notifyRequestDTO
     */
    void notifyDeveloper(NotifyRequestDTO notifyRequestDTO);

    /**
     * 开发者充值回调
     * @param virtualCallbackDTO
     */
    void virtualCallback(VirtualCallbackDTO virtualCallbackDTO);
}
