package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.utils;

import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SignTool {
    public SignTool() {
    }
    public static boolean signVerify(String appSecret, Object obj) {
        Map<String, String> map = new HashMap<>();
        Class<?> clazz = obj.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            Object value = null;
            try {
                value = field.get(obj);
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if(value!=null){
                map.put(fieldName, String.valueOf(value));
            }
        }
        return signVerify(appSecret,map);
    }
    public static boolean signVerify(String appSecret, Map<String, String> params) {
        Map<String, String> map = new HashMap();
        Iterator var3 = params.keySet().iterator();

        while(var3.hasNext()) {
            String key = (String)var3.next();
            if (!key.equals("sign") && !key.toLowerCase().equals("appsecret")) {
                map.put(key, params.get(key));
            }
        }

        map.put("appSecret", appSecret);
        String sign = sign(map);
        if (sign.equals(params.get("sign"))) {
            return true;
        } else {
            return false;
        }
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        } else {
            StringBuilder hexValue = new StringBuilder();
            byte[] var2 = messageDigest;
            int var3 = messageDigest.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                byte aMessageDigest = var2[var4];
                int val = 255 & aMessageDigest;
                if (val < 16) {
                    hexValue.append("0");
                }

                hexValue.append(Integer.toHexString(val));
            }

            return hexValue.toString();
        }
    }

    public static String sign(Map<String, String> params) {
        List<String> keys = new ArrayList(params.keySet());
        Collections.sort(keys);
        String string = "";

        String s;
        for(Iterator var3 = keys.iterator(); var3.hasNext(); string = string + (String)params.get(s)) {
            s = (String)var3.next();
        }

        String sign = "";

        try {
            sign = toHexValue(encryptMD5(string.getBytes(Charset.forName("utf-8"))));
            return sign;
        } catch (Exception var5) {
            var5.printStackTrace();
            throw new RuntimeException("md5 error");
        }
    }

    private static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    public static void main(String[] args) {
        String appKey = "key";
        String appSecret = "secret";
        Map<String, String> params = new HashMap();
        params.put("appKey", appKey);
        params.put("appSecret", appSecret);
        params.put("date", (new Date()).getTime() + "");
        String sign = sign(params);
        params.put("sign", sign);
        System.out.println(signVerify(appSecret, (Map)params));
    }
}
