/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.openapi.service.api.thirdparty.utils;

import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SignTool {
    public static boolean signVerify(String appSecret, Object obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        Class<?> clazz = obj.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (value == null) continue;
            map.put(fieldName, String.valueOf(value));
        }
        return SignTool.signVerify(appSecret, map);
    }

    public static boolean signVerify(String appSecret, Map<String, String> params) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : params.keySet()) {
            if (key.equals("sign") || key.toLowerCase().equals("appsecret")) continue;
            map.put(key, params.get(key));
        }
        map.put("appSecret", appSecret);
        String sign = SignTool.sign(map);
        return sign.equals(params.get("sign"));
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        byte[] var2 = messageDigest;
        int var3 = messageDigest.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            byte aMessageDigest = var2[var4];
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String sign(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String string = "";
        for (String s : keys) {
            string = string + params.get(s);
        }
        String sign = "";
        try {
            sign = SignTool.toHexValue(SignTool.encryptMD5(string.getBytes(Charset.forName("utf-8"))));
            return sign;
        }
        catch (Exception var5) {
            var5.printStackTrace();
            throw new RuntimeException("md5 error");
        }
    }

    private static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    public static void main(String[] args) {
        String appKey = "key";
        String appSecret = "secret";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appKey", appKey);
        params.put("appSecret", appSecret);
        params.put("date", new Date().getTime() + "");
        String sign = SignTool.sign(params);
        params.put("sign", sign);
        System.out.println(SignTool.signVerify(appSecret, params));
    }
}

