package cn.com.duiba.cloud.physical.goods.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.physical.goods.service.api.model.param.CreateDispatchBillParam;
import cn.com.duiba.cloud.physical.goods.service.api.model.param.DeliverGoodsParam;

/**
 * @Description 物流、发货写相关
 * @Author dangcang
 * @Date 2021/11/14 10:00 上午
 **/
@AdvancedFeignClient
public interface RemoteLogisticsWriteService {

    /**
     * 实物发货接口
     * @param param
     * @return
     * @throws BizException
     */
    Boolean physicalGoodsDelivery(DeliverGoodsParam param) throws BizException;

    /**
     * 创建发货单
     * @param param
     * @return
     * @throws BizException
     */
    Boolean createDispatchBill(CreateDispatchBillParam param) throws BizException;
}