package cn.com.duiba.cloud.physical.goods.service.api.utils;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.physical.goods.service.api.exception.ErrorCode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @Description 断言类
 * @Author dangcang
 * @Date 2021/11/11 4:08 下午
 **/
public class AssertUtil {

    private AssertUtil() {
    }

    public static void allNotBlank(List<String> stringList, ErrorCode code, Object... org) throws BizException {
        for (String str : stringList) {
            isNotBlank(str, code, org);
        }
    }

    public static void allNotNull(List<Object> objectList, ErrorCode code, Object... org) throws BizException {
        for (Object o : objectList) {
            isNotNull(o, code, org);
        }
    }

    public static void isBlank(String str, ErrorCode code, Object... org) throws BizException {
        isTrue(StringUtils.isBlank(str), code, org);
    }

    public static void isNotBlank(String str, ErrorCode code, Object... org) throws BizException {
        isTrue(StringUtils.isNotBlank(str), code, org);
    }

    public static void isEmpty(String str, ErrorCode code, Object... org) throws BizException {
        isTrue(StringUtils.isEmpty(str), code, org);
    }

    public static void isNotEmpty(String str, ErrorCode code, Object... org) throws BizException {
        isTrue(StringUtils.isNotEmpty(str), code, org);
    }

    public static void isNotNull(Object o, ErrorCode code, Object... org) throws BizException {
        isTrue(o != null, code, org);
    }

    public static void isNull(Object o, ErrorCode code, Object... org) throws BizException {
        isTrue(o == null, code, org);
    }

    public static void isNotEmpty(Collection c, ErrorCode code, Object... org) throws BizException {
        isTrue(CollectionUtils.isNotEmpty(c), code, org);
    }

    public static void isEmpty(Collection c, ErrorCode code, Object... org) throws BizException {
        isTrue(CollectionUtils.isEmpty(c), code, org);
    }

    public static void isMapNotEmpty(Map m, ErrorCode code, Object... org) throws BizException {
        isTrue(m != null && !m.isEmpty(), code, org);
    }

    public static void isMapEmpty(Map m, ErrorCode code, Object... org) throws BizException {
        isTrue(m == null || m.isEmpty(), code, org);
    }


    public static void isTrue(boolean as, ErrorCode code, Object... org) throws BizException {
        if (code == null) {
            code = ErrorCode.ERROR;
        }
        if (!as) {
            String errorMsg = getErrorMsg(code.getMsg(), org);
            BizException bizException = new BizException(errorMsg).withCode(code.getCode());
            throw bizException;
        }
    }

    public static String getErrorMsg(String str, Object... objects) {
        String rlt = str;
        if (objects != null) {
            for (Object object : objects) {
                rlt = rlt.replaceFirst("\\[.*?]", object == null ? "null" : object.toString());
            }
        }
        return rlt;
    }

    public static void main(String[] args) throws BizException{

        //anyBlack(Arrays.asList("1","","you"), ErrorCode.PARAM_MISS);
        allNotNull(Arrays.asList((int)1, 2L, null), ErrorCode.PARAM_MISS);
    }

}