package cn.com.duiba.cloud.risk.engine.api.dto.strategy;

import cn.com.duiba.cloud.risk.engine.api.dto.rule.RuleDetailDTO;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 策略详情DTO
 *
 * @author zouwx
 * @date 2022/02/09
 */
@Data
public class StrategyDetailDTO implements Serializable {

    private static final long serialVersionUID = 7886707715001240320L;

    /**
     * id
     */
    private Long id;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 策略名称
     */
    private String strategyName;


    /**
     * 策略描述
     */
    private String strategyDesc;

    /**
     * 场景列表
     */
    private List<Long> sceneIdList;

    /**
     * 规则id
     */
    private List<RuleDetailDTO> ruleList;

    /**
     * 低风险分
     */
    private Integer lowScore;

    /**
     * 高风险分
     */
    private Integer highScore;

    /**
     * 启用
     */
    private Integer enable;
}
