package cn.com.duiba.cloud.risk.engine.api.constants.enums;


import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;

@Getter
public enum BlackWhiteCreateWayEnum {

    /**
     * 在线方式
     */
    ONLINE(1),
    /**
     * 文件导入方式
     */
    FILE_IMPORT(2);

    private final Integer value;

    BlackWhiteCreateWayEnum(Integer value) {
        this.value = value;
    }

    public static BlackWhiteCreateWayEnum get(Integer value) throws BizException {
        for (BlackWhiteCreateWayEnum item : BlackWhiteCreateWayEnum.values()) {
            if (item.getValue().equals(value)) {
                return item;
            }
        }
        throw new BizException("数据录入方式参数错误");
    }
}
