package cn.com.duiba.cloud.risk.engine.api.constants.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 风险冲击枚举
 *
 * @author zouwx
 * @date 2022/02/21
 */
@Getter
public enum RiskHitEnum {

    /**
     * 分险命中类型
     */
    LOW(1, "低分险"),
    AUDIT(2, "审核"),
    HEIGHT(3, "高风险"),
    ;

    private Integer type;

    private String desc;

    RiskHitEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, RiskHitEnum> ENUM_MAP = new HashMap<>();

    static {
        for (RiskHitEnum tmp : values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static RiskHitEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
