package cn.com.duiba.cloud.risk.engine.api.constants.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 策略相关枚举类型
 *
 * @author zouwx
 * @date 2022/02/01
 */
@Getter
public enum StrategyRelatedTypeEnum {


    /**
     * 规则
     */
    RULE(1,"规则"),

    /**
     * 场景
     */
    SCENE(2,"场景")
    ;

    private Integer type;

    private String desc;

    StrategyRelatedTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, StrategyRelatedTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (StrategyRelatedTypeEnum tmp : values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static StrategyRelatedTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
