package cn.com.duiba.cloud.risk.engine.api.dto.strategy;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 策略节点dto
 *
 * @author zouwx
 * @date 2022/02/07
 */
@Data
public class StrategyNodeDTO implements Serializable {

    private static final long serialVersionUID = 6997541087909821070L;

    /**
     * 节点Id
     */
    private Long nodeId;

    /**
     * 节点名称
     */
    private String nodeName;

    /**
     * 启用
     */
    private Integer enable;
    /**
     * 节点类型
     *
     * @see cn.com.duiba.cloud.risk.engine.api.constants.enums.NodeTypeEnum
     */
    private Integer nodeType;

    /**
     * 上级节点
     */
    private Long preNodeId;

    /**
     * 下一个节点id
     */
    private Long nextNodeId;

    /**
     * 子节点
     */
    private List<StrategyNodeDTO> childNode = new ArrayList<>();

}
