package cn.com.duiba.cloud.risk.engine.api.constants.enums;

import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;

/**
 * 黑白名单类型枚举
 */
@Getter
public enum BlackWhiteEnum {

    /**
     * 黑名单
     */
    BLACK(1, "黑名单"),
    /**
     * 白名单
     */
    WHITE(2, "白名单");
    /**
     * 值
     */
    private Integer value;

    /**
     * desc
     */
    private String desc;

    BlackWhiteEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static BlackWhiteEnum get(Integer value) throws BizException {
        for (BlackWhiteEnum item : BlackWhiteEnum.values()) {
            if (item.getValue().equals(value)) {
                return item;
            }
        }
        throw new BizException("名单类型入参错误");
    }

}
