package cn.com.duiba.cloud.risk.engine.api.dto.risk;

import cn.com.duiba.cloud.risk.engine.api.constants.enums.RiskHitEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * 风控引擎结果
 *
 * @author zouwx
 * @date 2022/02/15
 */
@Data
public class RiskEngineResult implements Serializable {

    private static final long serialVersionUID = 3248787035551871550L;

    /**
     * 是否拒绝
     * @see cn.com.duiba.cloud.risk.engine.api.constants.enums.RiskHitEnum
     */
    private Integer reject;

    /**
     * 风险分
     */
    private Integer score;

    /**
     * 详情
     */
    private String desc;

    public RiskEngineResult() {
    }


    public RiskEngineResult(Integer reject, Integer score, String desc) {
        this.reject = reject;
        this.score = score;
        this.desc = desc;
    }
}
