package cn.com.duiba.cloud.risk.engine.api.dto.log;

import cn.com.duiba.cloud.risk.engine.api.constants.enums.RiskHitEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 风险日志分页结果
 *
 * @author zouwx
 * @date 2022/06/18
 */
@Data
public class RiskLogPageDTO implements Serializable {

    private static final long serialVersionUID = 6480929774325355326L;

    /**
     * 风险id
     */
    private Long riskId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 消费者id
     */
    private Long consumerId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 策略名称
     */
    private String strategyName;

    /**
     * @see RiskHitEnum
     * 结果
     */
    private Integer result;

    /**
     * ip
     */
    private String ip;

    /**
     * 地址名称
     */
    private String addressName;

    /**
     * 风险评分
     */
    private String riskScore;

    /**
     * 应用程序id
     */
    private Long appId;
}
