package cn.com.duiba.cloud.risk.engine.api.param.log;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 风险日志查询分页参数
 *
 * @author zouwx
 * @date 2022/06/18
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RiskLogQueryPageParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = -2766948733879725883L;

    /**
     * 创建开始时间
     */
    private Date createStartTime;

    /**
     * 创建结束时间
     */
    private Date createEndTime;

    /**
     * 消费者id
     */
    private Long consumerId;

    /**
     * 应用程序名称
     */
    private String appName;

    /**
     * 应用程序id
     */
    private Long appId;

    /**
     * 策略名称
     */
    private String strategyName;

    /**
     * 结果
     * @see cn.com.duiba.cloud.risk.engine.api.constants.enums.RiskHitEnum
     */
    private Integer result;

    /**
     * 风险区间低区间
     */
    private Integer riskLowScore;

    /**
     * 风险区间高区间
     */
    private Integer riskHeightScore;
}
