package cn.com.duiba.cloud.risk.engine.api.constants.enums;

import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;

/**
 * 黑白名单属性类型枚举
 */
@Getter
public enum BlackWhitePropertyTypeEnum {

    /**
     * 用户Id
     */
    USER_ID(1, "用户ID", QueryEnum.EXACT,""),
    /**
     * 用户手机号
     */
    PHONE(2, "手机号", QueryEnum.EXACT,"^1[3-9]\\d{9}$"),
    /**
     * 用户加密手机号
     */
    ENCRYPTION_PHONE(3, "加密手机号", QueryEnum.EXACT,"^([a-f\\d]{32})$"),
    /**
     * ip地址
     */
    IPV_4(4, "IPV4", QueryEnum.RIGHT_FUZZY,"^((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$"),
    /**
     * ip地址
     */
    IPV_6(5, "IPV6", QueryEnum.RIGHT_FUZZY,"^([\\da-fA-F]{1,4}:){7}[\\da-fA-F]{1,4}$"),
    /**
     * 地址
     */
    ADDRESS(6, "地址", QueryEnum.ALL_FUZZY,"(?<province>[^省]+省|.+自治区)(?<city>[^市]+市|.+区|.+自治州)(?<county>[^县]+县|.+区|.+镇|.+局)?(?<town>[^区]+区|.+县|.+镇)(.*)|(上海市|北京市|天津市|重庆市)([^区]+区|.+自治州)(.*)"),
    ;
    private final Integer value;

    private final String name;

    private final QueryEnum query;

    private final String pattern;

    BlackWhitePropertyTypeEnum(Integer value, String name, QueryEnum query,String pattern) {
        this.value = value;
        this.name = name;
        this.query = query;
        this.pattern = pattern;
    }

    public static BlackWhitePropertyTypeEnum get(Integer value) throws BizException {
        for (BlackWhitePropertyTypeEnum item : BlackWhitePropertyTypeEnum.values()) {
            if (item.getValue().equals(value)) {
                return item;
            }
        }
        throw new BizException("属性类型入参错误");
    }
}
