package cn.com.duiba.cloud.risk.engine.api.constants.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 运算类型
 *
 * @author zouwx
 * @date 2022/01/24
 */
@Getter
public enum OperatorTypeEnum {

    /**
     * 操作类型
     */
    NUMBER(0, "数值"),
    BOOL(1, "布尔"),

    ;

    private Integer type;

    private String desc;

    OperatorTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, OperatorTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (OperatorTypeEnum tmp : values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static OperatorTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
