package cn.com.duiba.cloud.risk.engine.api.constants.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description 规则条件满足情况枚举类
 * @Author dangcang
 * @Date 2022/1/26 1:33 下午
 **/
@Getter
public enum RuleConditionEnum {

    /**
     *  规则条件状态
     */
    ANY_ONE(1, "任意条件"),
    ALL(2, "所有条件"),
    ;

    private Integer type;

    private String desc;

    RuleConditionEnum(Integer type, String desc) {
        this.desc = desc;
        this.type = type;
    }

    private static final Map<Integer, RuleConditionEnum> ENUM_MAP = new HashMap<>();

    static {
        for (RuleConditionEnum tmp : values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static RuleConditionEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}