package cn.com.duiba.cloud.risk.engine.api.param.blackwhite;

import cn.com.duiba.cloud.risk.engine.api.constants.enums.BlackWhiteDimensionEnum;
import cn.com.duiba.cloud.risk.engine.api.constants.enums.BlackWhiteEnum;
import cn.com.duiba.cloud.risk.engine.api.constants.enums.BlackWhitePropertyTypeEnum;
import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 黑白名单分页查询入参
 *
 * @author zouwx
 * @date 2022/06/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BlackWhiteQueryPageParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = -1487166333656900572L;

    /**
     * 列表类型 白名单 黑名单
     * @see BlackWhiteEnum
     */
    @NotNull(message = "列表类型不得为空")
    private Integer listType;

    /**
     * tab类型
     * @see BlackWhiteDimensionEnum
     */
    @NotNull(message = "tab类型不得为空")
    private Integer dimensionType;

    /**
     * 属性类型
     * @see BlackWhitePropertyTypeEnum
     */
    private List<Integer> propertyTypeList;

    /**
     * 值查询
     */
    private String value;

    /**
     * 值列表
     */
    private List<String> valueList;
}
