package cn.com.duiba.cloud.risk.engine.api.param.risk;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 规则引擎参数
 *
 * @author zouwx
 * @date 2022/02/15
 */
@Data
public class RiskEngineParam implements Serializable {

    private static final long serialVersionUID = 3284670712197560523L;

    /**
     * 消费者id
     */
    @NotBlank(message = "用户id不能为空")
    private String consumerId;

    /**
     * 策略业务code
     */
    @NotBlank(message = "用户id不能为空")
    private String streamBizCode;

    /**
     * 设备id
     */
    private String deviceId;

    /**
     * ip
     */
    @NotBlank(message = "ip不能为空")
    private String ip;

    /**
     * 应用程序id
     */
    private Long appId;

    /**
     * ua
     */
    private String ua;

    /**
     * 手机号：选传，没有时为空即可
     */
    private String phone;

    /**
     * 地址，用于黑名单拦截
     */
    private String address;

    /**
     * 日期
     */
    private Date date;

    /**
     * 设备类型(platform)：IOS、Android、H5，必传
     */
    private String platform;

}
