package cn.com.duiba.cloud.risk.engine.api.param.strategy;

import cn.com.duiba.cloud.risk.engine.api.dto.strategy.StrategyNodeDTO;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 创建策略流入参
 *
 * @author zouwx
 * @date 2022/06/12
 */
@Data
public class RemoteAddStrategyStreamParam implements Serializable {

    private static final long serialVersionUID = 6042617586374814747L;
    /**
     * 场景id
     */
    @NotNull(message = "场景id不能为空")
    private Long sceneId;

    /**
     * 策略流名称
     */
    @NotBlank(message = "策略流名称不能为空")
    private String strategyStreamName;

    /**
     * 管理员id
     */
    private Long adminId;

    /**
     * 节点列表
     */
    @NotEmpty(message = "节点不能为空")
    private List<StrategyNodeDTO> nodeList;
}
