package cn.com.duiba.cloud.risk.engine.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.risk.engine.api.dto.event.EventAttrDTO;
import cn.com.duiba.cloud.risk.engine.api.dto.event.SceneDTO;
import cn.com.duiba.cloud.risk.engine.api.param.event.QueryEventAttrParam;
import cn.com.duiba.cloud.risk.engine.api.param.event.QueryEventConditionParam;
import cn.com.duiba.cloud.risk.engine.api.param.event.QuerySceneParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 远程事件服务
 *
 * @author zouwx
 * @date 2022/06/12
 */
@AdvancedFeignClient
public interface RemoteEventService {

    /**
     * 查询场景列表
     *
     * @param querySceneParam 查询场景参数
     * @return {@link List}<{@link SceneDTO}>
     */
    PageResponse<SceneDTO> findSceneList(QuerySceneParam querySceneParam);

    /**
     * 查询场景根据id
     *
     * @param id id
     * @return {@link SceneDTO}
     */
    SceneDTO findSceneById(Long id);

    /**
     * 查询事件列表
     *
     * @param queryEventAttrParam 查询事件attr参数
     * @return {@link List}<{@link EventAttrDTO}>
     */
    PageResponse<EventAttrDTO> findEventAttr(QueryEventAttrParam queryEventAttrParam);

    /**
     * 通过id查询事件
     *
     * @param id id
     * @return {@link EventAttrDTO}
     */
    EventAttrDTO findEventAttrById(Long id);

    /**
     * 根据条件查询事件
     *
     * @param param 参数
     * @return {@link List}<{@link EventAttrDTO}>
     */
    List<EventAttrDTO> findEventAttrByCondition(QueryEventConditionParam param);
}
