package cn.com.duiba.cloud.risk.engine.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.risk.engine.api.dto.log.RiskLogDetailDTO;
import cn.com.duiba.cloud.risk.engine.api.dto.log.RiskLogPageDTO;
import cn.com.duiba.cloud.risk.engine.api.param.log.RiskLogQueryPageParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 远程风控日志服务
 *
 * @author zouwx
 * @date 2022/06/18
 */
@AdvancedFeignClient
public interface RemoteRiskLogService {

    /**
     * 分页查询
     *
     * @param param 参数
     * @return {@link PageResponse}<{@link RiskLogPageDTO}>
     */
    PageResponse<RiskLogPageDTO> findPage(RiskLogQueryPageParam param);

    /**
     * 查询风控详情
     *
     * @param riskId 风险id
     * @return {@link RiskLogDetailDTO}
     */
    RiskLogDetailDTO getDetail(Long riskId) throws BizException;
}
