package cn.com.duiba.cloud.risk.engine.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.risk.engine.api.dto.strategy.RemoteStrategyPageListDTO;
import cn.com.duiba.cloud.risk.engine.api.dto.strategy.RemoteStrategySaveDTO;
import cn.com.duiba.cloud.risk.engine.api.dto.strategy.StrategyDetailDTO;
import cn.com.duiba.cloud.risk.engine.api.param.RemoteBaseParam;
import cn.com.duiba.cloud.risk.engine.api.param.strategy.RemoteStrategyPageParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 策略rpc调用
 *
 * @author zouwx
 * @date 2022/01/25
 */
@AdvancedFeignClient
public interface RemoteStrategyService {

    /**
     * 策略分页列表
     *
     * @param strategyPageParam 策略页面参数
     * @return {@link PageResponse}<{@link RemoteStrategyPageListDTO}>
     */
    PageResponse<RemoteStrategyPageListDTO> findStrategyPageList(RemoteStrategyPageParam strategyPageParam);


    /**
     * 保存策略
     *
     * @param remoteStrategySaveDTO 保存
     * @return {@link RemoteBaseParam}
     * @throws BizException 业务异常
     */
    RemoteBaseParam saveStrategy(RemoteStrategySaveDTO remoteStrategySaveDTO) throws BizException;

    /**
     * 找到策略通过id
     *
     * @param param 参数
     * @return {@link RemoteStrategySaveDTO}
     * @throws BizException 业务异常
     */
    StrategyDetailDTO findStrategyById(RemoteBaseParam param) throws BizException;

    /**
     * 删除策略
     *
     * @param param 参数
     * @throws BizException 业务异常
     */
    void delStrategy(RemoteBaseParam param) throws BizException;

    /**
     * 启用策略
     *
     * @param param 参数
     * @throws BizException 业务异常
     */
    void enableStrategy(RemoteBaseParam param) throws BizException;

}
