/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.risk.engine.api.constants.enums;

import java.util.HashMap;
import java.util.Map;

public enum OperatorEnum {
    GT(0, ">"),
    LT(1, "<"),
    EQ(2, "=="),
    GTE(3, ">="),
    LTE(4, "<="),
    NEQ(5, "!="),
    CONTAINS(6, "\u5305\u542b"),
    NOT_CONTAINS(7, "\u4e0d\u5305\u542b");

    private Integer type;
    private String desc;
    private static final Map<Integer, OperatorEnum> ENUM_MAP;

    private OperatorEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static OperatorEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ENUM_MAP = new HashMap<Integer, OperatorEnum>();
        for (OperatorEnum tmp : OperatorEnum.values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }
}

