package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.param;

import lombok.Data;

import java.io.Serializable;

/**
 * 限流规则配置
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/7 4:55 下午
 **/
@Data
public class FlowRuleParam implements Serializable {
    /**
     * 限流资源名称
     */
    private String resource;

    /**
     * 规则归属（设置该规则的应用名）
     */
    private String ownerApp;

    /**
     * 流控针对的调用来源，可以根据目标应用名来区分
     * default，代表不区分调用来源
     */
    private String limitApp;

    /**
     * 调用关系限流策略：直接、链路、关联
     * 根据资源本身（直接）
     */
    private Integer strategy;

    /**
     * 限流阈值类型，QPS-0 或线程数模式-1
     * 默认：QPS 模式
     */
    private Integer grade;

    /**
     * 限流阈值
     */
    private String count;
    /**
     * 流控效果（直接拒绝 / 排队等待 / 慢启动模式），不支持按调用关系限流
     * 默认：直接拒绝
     */
    private String controlBehavior;

    /**
     * 是否集群模式
     * 默认：否
     */
    private Boolean clusterMode;

    /**
     * 集群模式 配置
     */
    private ClusterConfig clusterConfig;

    @Data
    public static class ClusterConfig implements Serializable {
        /**
         * token-server失败是否用本地
         */
        private String fallbackToLocalWhenFail;

        /**
         * 阈值模式 单机-0 集群-1
         */
        private String thresholdType;

        /**
         * 窗口时间
         * 默认 1000
         */
        private String windowIntervalMs;
    }

}
