package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.constant;

/**
 * @author huangguosheng@duiba.com.cn
 * @date 2022/2/25 3:08 下午
 **/
public class SentinelCommonConstants {
   public interface Config {
        /**
         * ${app}-cluster-map
         */
        String APP_CLUSTER_MAP_SUFFIX = "-cluster-map";

        /**
         * ${app}-flow-rules
         */
        String APP_FLOW_RULES_SUFFIX = "-flow-rules";

        /**
         * ${app}-param-rules
         */
        String APP_PARAM_FLOW_POSTFIX = "-param-rules";

        /**
         * token-server-info
         */
        String TOKEN_SERVER_INFO = "token-server-info";

        /**
         * 客户端配置
         * cluster-client-config
         */
        String CLUSTER_CLIENT_CONFIG = "cluster-client-config";


        /**
         * server-cluster-map-config
         */
        String SERVER_CLUSTER_MAP_CONFIG = "server-cluster-map-config";
    }


    /******** MQ *********/

   public interface MqConfig {
        String SENTINEL_NOTICE_TOPIC = "duiba-sentinel-notice";
    }

    public static String buildDestination(String namespace) {
        return MqConfig.SENTINEL_NOTICE_TOPIC + ":" + namespace;
    }

}
