package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.consumer;

import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.constant.SentinelCommonConstants;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.enums.SentinelConfigTypeEnum;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * 消息推送，MQ监听
 * 目前采用的都是弱推送，最多只会推送两次
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/6 4:20 下午
 **/
@Slf4j
@ConditionalOnProperty(prefix = "duiba.sentinel", name = "enable", havingValue = "true")
@RocketMQMessageListener(
        topic = SentinelCommonConstants.MqConfig.SENTINEL_NOTICE_TOPIC,                      // 1.topic：消息的发送者使用同一个topic
        consumerGroup = "sentinel-notice-group",               // 2.group：不用和生产者group相同 ( 在RocketMQ中消费者和发送者组没有关系 )
        selectorExpression = "${duiba.sentinel.namespace}",                   // 3.tag：设置为 * 时，表示全部。
        messageModel = MessageModel.BROADCASTING    // 4.消费模式：默认 CLUSTERING （ CLUSTERING：负载均衡 ）（ BROADCASTING：广播机制 ）
)
@Component
public class SentinelNoticeConsumer implements RocketMQListener<String> {

    @Resource(name = "threadPoolTaskExecutor")
    private ThreadPoolTaskExecutor taskExecutor;

    @SneakyThrows
    @Override
    public void onMessage(String message) {
        log.info("接收QM消息成功 message:{} ", message);

        if (StringUtils.isBlank(message)) {
            log.error("消息推送事件处理失败，消息内容为空，请检查 message:{}", message);
            return;
        }
        JSONObject msgJson = JSON.parseObject(message);

        String content = msgJson.getString("content");
        Integer configType = msgJson.getInteger("configType");
        if(SentinelConfigTypeEnum.FLOW_RULE.getValue().equals(configType)){
            List<FlowRule> rules = FlowRuleManager.getRules();
            rules.add(JSON.parseObject(content,FlowRule.class));
            FlowRuleManager.loadRules(rules);
        }
    }
}
