package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.param;

import lombok.Data;

import java.io.Serializable;

/**
 * 限流规则配置
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/7 4:55 下午
 **/
@Data
public class FlowRuleParam implements Serializable {
    private static final long serialVersionUID = 8842078815190924254L;
    /**
     * 限流资源名称
     */
    private String resource;

    /**
     * 规则归属（设置该规则的应用名）
     */
    private String namespace;

    /**
     * 流控针对的调用来源，可以根据目标应用名来区分
     * default，代表不区分调用来源
     */
    private String limitApp = "default";

    /**
     * 调用关系限流策略：直接、链路、关联
     * 根据资源本身（直接）
     */
    private Integer strategy = 1;

    /**
     * 限流阈值类型，线程数模式-0、QPS-1
     * 默认：QPS 模式
     */
    private Integer grade = 1;

    /**
     * 限流阈值
     */
    private Integer count;
    /**
     * 流控效果（直接拒绝 / 排队等待 / 慢启动模式），不支持按调用关系限流
     * 默认：直接拒绝
     */
    private Integer controlBehavior = 0;

    /**
     * 是否集群模式
     * 默认：否
     */
    private Boolean clusterMode = false;

    /**
     * 集群模式 配置
     */
    private ClusterConfig clusterConfig;

    @Data
    public static class ClusterConfig implements Serializable {
        private static final long serialVersionUID = -5661022568092372630L;
        /**
         * token-server失败是否用本地
         */
        private Boolean fallbackToLocalWhenFail = true;

        /**
         * 阈值模式 单机-0 集群-1
         */
        private Integer thresholdType = 1;


        /**
         * 调用关系限流策略：直接-0、链路-1、关联-2
         * 根据资源本身（直接）
         */
        private Integer strategy = 0;

        /**
         * 窗口时间
         * 默认 1000
         */
        private Integer windowIntervalMs = 1000;
    }

}
