package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.consumer;

import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.config.DuibaSentinelDataSource;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.constant.SentinelCommonConstants;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.enums.SentinelConfigTypeEnum;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.param.ConfigNoticeParam;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.param.FlowRuleDeleteParam;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.fastjson.JSON;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 消息推送，MQ监听
 * 目前采用的都是弱推送，最多只会推送两次
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/6 4:20 下午
 **/
@Slf4j
@RocketMQMessageListener(
        topic = SentinelCommonConstants.MqConfig.SENTINEL_NOTICE_TOPIC,                      // 1.topic：消息的发送者使用同一个topic
        consumerGroup = "sentinel-notice-group",               // 2.group：不用和生产者group相同 ( 在RocketMQ中消费者和发送者组没有关系 )
        selectorExpression = "*",                   // 3.tag：设置为 * 时，表示全部。
        messageModel = MessageModel.BROADCASTING    // 4.消费模式：默认 CLUSTERING （ CLUSTERING：负载均衡 ）（ BROADCASTING：广播机制 ）
)
@ConditionalOnProperty(prefix = "duiba.sentinel", name = "enable", havingValue = "true")
@Component
public class SentinelNoticeConsumer implements RocketMQListener<String> {
    @Value("${duiba.sentinel.namespace}")
    private String namespace;

    @SneakyThrows
    @Override
    public void onMessage(String message) {
        log.info("接收QM消息成功 message:{} ", message);
        if (StringUtils.isBlank(message)) {
            log.error("消息推送事件处理失败，消息内容为空，请检查 message:{}", message);
            return;
        }

        ConfigNoticeParam noticeParam = JSON.parseObject(message, ConfigNoticeParam.class);
        if (!SentinelConfigTypeEnum.TOKEN_SERVER_INFO.getValue().equals(noticeParam.getConfigType())
                && !noticeParam.getNamespace().equals(namespace)) {
            log.info("非该namespace消息跳过处理");
            return;
        }

        if (SentinelConfigTypeEnum.FLOW_RULE.getValue().equals(noticeParam.getConfigType())) {
            FlowRule newFlowRule = JSON.parseObject(noticeParam.getContent(), FlowRule.class);
            List<FlowRule> rules = FlowRuleManager.getRules();
            List<FlowRule> curRules = rules.stream().filter(item -> !item.getResource().equals(newFlowRule.getResource())).collect(Collectors.toList());
            curRules.add(newFlowRule);
          //  FlowRuleManager.loadRules(curRules);


            DuibaSentinelDataSource<List<FlowRule>> dataSource = new DuibaSentinelDataSource<>(JSON.toJSONString(Arrays.asList(newFlowRule)), parser ->{ return JSON.parseArray(parser,FlowRule.class);});
            FlowRuleManager.register2Property(dataSource.getProperty());
        } else if (SentinelConfigTypeEnum.TOKEN_SERVER_INFO.getValue().equals(noticeParam.getConfigType())) {
            ClusterClientAssignConfig clusterClientAssignConfig = JSON.parseObject(noticeParam.getContent(), ClusterClientAssignConfig.class);
            ClusterClientConfigManager.applyNewAssignConfig(clusterClientAssignConfig);
        }else if(SentinelConfigTypeEnum.FLOW_RULE_DELETE.getValue().equals(noticeParam.getConfigType())){
            FlowRuleDeleteParam deleteParam = JSON.parseObject(noticeParam.getContent(), FlowRuleDeleteParam.class);
            List<FlowRule> flowRules = FlowRuleManager.getRules();
            flowRules = flowRules.stream().filter(item -> !item.getResource().equals(deleteParam.getResource())).collect(Collectors.toList());
            FlowRuleManager.loadRules(flowRules);
        }
    }
}
