package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.constant;

/**
 * @author huangguosheng@duiba.com.cn
 * @date 2022/2/25 3:08 下午
 **/
public class SentinelCommonConstants {
    public interface Config {
        String PRE = "duiba-sentinel-server-";

        /**
         * ${app}-flow-rules
         */
        String APP_FLOW_RULES_SUFFIX = PRE + "{namespace}-flow-rules";

        /**
         * ${app}-param-rules
         */
        String APP_PARAM_FLOW_POSTFIX = PRE + "{namespace}-param-rules";

        /**
         * token-server-info
         */
        String TOKEN_SERVER_INFO = PRE + "token-server-info";

        /**
         * 客户端配置
         * cluster-client-config
         */
        String CLUSTER_CLIENT_CONFIG = PRE + "cluster-client-config";


        /**
         * 命名空间，set
         * client-namespace-set-config
         */
        String CLIENT_NAMESPACE_SET_CONFIG = PRE + "client-namespace-set-config";

        /**
         * 在线token-server
         */
        String TOKEN_SERVER_HASH = PRE + "token-server-hash";
    }


    /******** MQ *********/

    public interface MqConfig {
        String SENTINEL_NOTICE_TOPIC = "duiba-sentinel-notice";
    }

    public static String buildDestination(String namespace) {
        return MqConfig.SENTINEL_NOTICE_TOPIC + ":" + namespace;
    }

}
